const {enviarMensagem} = require('../servicos/OmbalaSMS')
const {readDataBase, writeDataBase} = require('../config/database')


module.exports.enviarMensagemPagamento = async function (mensagem, pagamento) { 

    try {
        const verifyCliente = await readDataBase('configuracoes').where({cliente_entidade: pagamento.numero_entidade})
        const verifyRemetente = await readDataBase('envio_remetentes').where({entidade_remetente: pagamento.numero_entidade})
        const verifyDestinatario = await readDataBase('referencias').where({num_referencia: pagamento.referencia_do_servico})

        if(verifyCliente.length > 0){

            if(verifyCliente[0].servico_mensagens == "true"){

                if(verifyRemetente.length > 0){

                    if(verifyDestinatario.length > 0){
                        
                        const destinatario = verifyDestinatario[0][String(verifyRemetente[0].campo_envio)]

                        if(destinatario){
                            const destino = String(destinatario.split('=')[1]).trim()
                            let sms = new String(mensagem)
                            sms = sms.replaceAll('[data]', new Date(pagamento.data_movimento).toLocaleDateString());
                            sms = sms.replaceAll('[hora]', new Date(pagamento.hora_do_movimento).toLocaleTimeString());
                            sms = sms.replaceAll('[local]', pagamento.localidade);
                            sms = sms.replaceAll('[referencia]', pagamento.referencia_do_servico);
                            sms = sms.replaceAll('[entidade]', pagamento.numero_entidade);
                            sms = sms.replaceAll('[montante]', Intl.NumberFormat("PT-br").format(pagamento.montante_da_operacao));
                            sms = sms.replaceAll('[campo1]', String(pagamento.opcional_1).split('=')[1]);
                            sms = sms.replaceAll('[campo2]', String(pagamento.opcional_2).split('=')[1]);
                            sms = sms.replaceAll('[campo3]', String(pagamento.opcional_3).split('=')[1]);

                            try{
                                const {id} = await enviarMensagem(sms, verifyRemetente[0].nome_rementente, destino)
                                    if(id){
                                    await writeDataBase('envio_mensagens_clientes').insert({
                                        tipo_envio:"SMS", 
                                        id_envio_rementente_entidade: verifyRemetente[0].id_envio_rementente, 
                                        mensagem_envio: sms,
                                        custo_envio: 15.0
                                    })

                                    return {mensagem: "mensagem enviada com sucesso"}
                                }
                                return {mensagem: "mensagem enviada sem sucesso"}
                            }catch(e){
                                console.error(e)
                            }
                            
                        }
                    }
                }

            }
        }
    } catch (error) {
        console.error(error)
    }
    
}

module.exports.enviarMensagemReferencia = async function (mensagem, referencia) { 

    try {
        const verifyCliente = await readDataBase('configuracoes').where({cliente_entidade: referencia.entidade_cliente})
        const verifyRemetente = await readDataBase('envio_remetentes').where({entidade_remetente: referencia.entidade_cliente})
        const verifyDestinatario = await readDataBase('referencias').where({num_referencia: referencia.num_referencia})

        console.log(referencia)


        if(verifyCliente.length > 0){

            if(verifyCliente[0].servico_mensagens == "true"){

                if(verifyRemetente.length > 0){

                    if(verifyDestinatario.length > 0){
                        
                        const destinatario = verifyDestinatario[0][String(verifyRemetente[0].campo_envio)]

                        if(destinatario){
                            const destino = String(destinatario.split('=')[1]).trim()
                            let sms = String(mensagem)
                            sms = sms.replaceAll('[producao]',  new Date(referencia.data_inicio_de_pagamento).toLocaleDateString());
                            sms = sms.replaceAll('[expiracao]', new Date(referencia.data_limite_pagamento).toLocaleDateString());
                            sms = sms.replaceAll('[referencia]', referencia.num_referencia);
                            sms = sms.replaceAll('[entidade]', referencia.entidade_cliente);
                            sms = sms.replaceAll('[minimo]', referencia.montante_minimo);
                            sms = sms.replaceAll('[maximo]', referencia.montante_maximo);
                            sms = sms.replaceAll('[campo1]', String(referencia.opcional_1).split('=')[1]);
                            sms = sms.replaceAll('[campo2]', String(referencia.opcional_2).split('=')[1]);
                            sms = sms.replaceAll('[campo3]', String(referencia.opcional_3).split('=')[1]);

                            try{
                                const {id} = await enviarMensagem(sms, verifyRemetente[0].nome_rementente, destino)
                                    if(id){
                                    await writeDataBase('envio_mensagens_clientes').insert({
                                        tipo_envio:"SMS", 
                                        id_envio_rementente_entidade: verifyRemetente[0].id_envio_rementente, 
                                        mensagem_envio: sms,
                                        custo_envio: 15.0
                                    })

                                    return {mensagem: "mensagem enviada com sucesso"}
                                }
                                return {mensagem: "mensagem enviada sem sucesso"}
                            }catch(e){
                                console.error(e)
                            }
                            
                        }
                    }
                }

            }
        }
    } catch (error) {
        console.error(error)
    }
}

module.exports.enviarMensagemRecuperacaoDeSenha = async function (mensagem, cliente) { 

    try {
        
        try{
            const data = await enviarMensagem(mensagem, "radar360", cliente.contacto)
            console.log(data)
                if(data.id){
                await writeDataBase('envio_mensagens_clientes').insert({
                    tipo_envio:"SMS", 
                    id_envio_rementente_entidade: 5, 
                    mensagem_envio: mensagem,
                    custo_envio: 15.0
                })
                return {mensagem: "mensagem enviada com sucesso"}
            }
            return {mensagem: "mensagem enviada sem sucesso"}
        }catch(e){
            console.error(e)
        }
                            
                            
    } catch (error) {
        console.error(error)
    }
}

