const {
  transport: transportador,
  smtpConfig
} = require("../config/transportadorSMTP");
const bloqueioADM = require("./templates/bloqueioADM");
const bloqueioNormal = require("./templates/bloqueioNormal");
const codigoSeguranca = require("./templates/codigoSeguranca");
const confirmacaoDeConta = require("./templates/confirmacaoDeConta");
const confirmacaoDeContaLink = require("./templates/confirmacaoDeContaLink");
const desbloqueio = require("./templates/desbloqueio");
const pagamentos = require("./templates/pagamentos");
const referencia = require("./templates/referencia");

console.log(transportador)

module.exports.comunicarEmail = async (assunto, email, html) => {
  try {
    await transportador.sendMail({
      from: `"${smtpConfig.nome}" <${smtpConfig.usuario}>`,
      to: email,
      subject: assunto,
      html,
      headers: { "x-myheader": "test header" }
    });
  } catch (error) {
    console.error(error.message);
  }
};

module.exports.envioReferencia = async ({email, nome_empresa, numero_entidade, num_referencia, data_limite_pagamento, hora_limite_pagamento}) => {
  try {
    const dateRef = new Date(`${data_limite_pagamento} ${hora_limite_pagamento}`);
    const dataValidade = dateRef.toLocaleDateString()
    const horaValidade = dateRef.toLocaleTimeString()
    await transportador.sendMail({
      from: `"${smtpConfig.nome}" <${smtpConfig.usuario}>`,
      to: email,
      subject: "Referência de pagamentos - SONANGOL EP",
      html: referencia({nome_empresa, numero_entidade, num_referencia, dataValidade, horaValidade}),
      headers: { "x-myheader": "test header" }
    });
  } catch (error) {
    console.error(error.message);
  }
};

module.exports.envioPagamento = async ({email, nome_cliente, nome_empresa, numero_entidade, referencia_do_servico, montante_da_operacao, data_movimento, hora_do_movimento, Identificacao_Log_EGR, numero_Log_EGR, tipo_de_Terminal}) => {
  try {
    const datePag = new Date(`${data_movimento}`).toLocaleDateString();
    const transacao = `${Identificacao_Log_EGR}${numero_Log_EGR}`
    const valor = Intl.NumberFormat('pt-BR').format(montante_da_operacao)
    
    const terminal = {
      "A":"ATM",
      "M":"Multicaixa Express",
      "L":"Internet Bank"
    }
    await transportador.sendMail({
      from: `"${smtpConfig.nome}" <${smtpConfig.usuario}>`,
      to: email,
      subject: "Dados de pagamentos - SONANGOL EP",
      html: pagamentos({nome_cliente, nome_empresa, numero_entidade, referencia_do_servico, montante_da_operacao: valor, data_movimento: datePag, hora_do_movimento, transacao, terminal: terminal[tipo_de_Terminal]}),
      headers: { "x-myheader": "test header" }
    });
  } catch (error) {
    console.error(error.message);
  }
};

module.exports.saudacaoDeCadastro = async ({empresa, email}) => {
  try {
    await transportador.sendMail({
      from: `"${smtpConfig.nome}" <${smtpConfig.usuario}>`,
      to: email,
      subject: "Cadastro recebido com sucesso | Em breve será validado - SONANGOL EP",
      html: saudacaoDeCadastro(empresa),
      headers: { "x-myheader": "test header" }
    });
  } catch (error) {
    console.error(error.message);
  }
};

module.exports.codigoSeguranca = async ({empresa, email, codigo_seguranca}) => {
  try {
    await transportador.sendMail({
      from: `"${smtpConfig.nome}" <${smtpConfig.usuario}>`,
      to: email,
      subject: "Código de Confirmação MFA - SONANGOL EP",
      html: codigoSeguranca(empresa, codigo_seguranca),
      headers: { "x-myheader": "test header" }
    });
  } catch (error) {
    console.error(error.message);
  }
};

module.exports.confirmacaoDeConta = async ({empresa, email, codigo_seguranca}) => {
  try {
    await transportador.sendMail({
      from: `"${smtpConfig.nome}" <${smtpConfig.usuario}>`,
      to: email,
      subject: "Confirmação de conta - SONANGOL EP",
      html: confirmacaoDeConta(empresa, codigo_seguranca),
      headers: { "x-myheader": "test header" }
    });
  } catch (error) {
    console.error(error.message);
  }
};

module.exports.confirmacaoDeContaLink = async ({empresa, email, codigo_seguranca}) => {
  try {
    await transportador.sendMail({
      from: `"${smtpConfig.nome}" <${smtpConfig.usuario}>`,
      to: email,
      subject: "Confirmação de conta - SONANGOL EP",
      html: confirmacaoDeContaLink(empresa, codigo_seguranca),
      headers: { "x-myheader": "test header" }
    });
  } catch (error) {
    console.error(error.message);
  }
};

module.exports.bloququeioDeConta = async ({empresa, email}) => {
  try {
    await transportador.sendMail({
      from: `"${smtpConfig.nome}" <${smtpConfig.usuario}>`,
      to: email,
      subject: "Bloqueio de Perfil por Tentativas de Acesso - SONANGOL EP",
      html: bloqueioNormal(empresa),
      headers: { "x-myheader": "test header" }
    });
  } catch (error) {
    console.error(error.message);
  }
};

module.exports.bloququeioDeContaADM = async ({empresa, email}) => {
  try {
    await transportador.sendMail({
      from: `"${smtpConfig.nome}" <${smtpConfig.usuario}>`,
      to: email,
      subject: "Sua Conta Foi Bloqueada - SONANGOL EP",
      html: bloqueioADM(empresa),
      headers: { "x-myheader": "test header" }
    });
  } catch (error) {
    console.error(error.message);
  }
};

module.exports.desbloququeioDeContaADM = async ({empresa, email}) => {
  try {
    await transportador.sendMail({
      from: `"${smtpConfig.nome}" <${smtpConfig.usuario}>`,
      to: email,
      subject: "Sua Conta Foi Desbloqueada - SONANGOL EP",
      html: desbloqueio(empresa),
      headers: { "x-myheader": "test header" }
    });
  } catch (error) {
    console.error(error.message);
  }
};

